#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{


	[TestFixture]
	public class HL7AL_InterfaceControl : BaseTest 
	{
		private const Common.InterfaceName _testInterfaceName = Common.InterfaceName.CPRS;
		private const string TestVbecsAppID = "VBECS";
		private const string TestInterfaceAppID = "OERR";

		private DataRow _testInterfaceReserveCopy;
		private DataRow _testInterfaceWorkingCopy;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_testInterfaceReserveCopy = GetTestInterfaceControlParametersDataRow();
			_testInterfaceWorkingCopy = GetTestInterfaceControlParametersDataRow();
		}

		[TearDown]
		protected void TearDown()
		{
			InterfaceControl.UpdateInterface( _testInterfaceReserveCopy );

			_testInterfaceReserveCopy = null;
			_testInterfaceWorkingCopy = null;
		}

		[Test]
		public void GetAllHL7Interfaces_Pass()
		{
			Assert.IsTrue( InterfaceControl.GetAllHL7Interfaces().Rows.Count > 0 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod )]
		public void GetAllHL7Interfaces_Fail(){}

		[Test]
		public void GetInterfaceControlParameters_Pass()
		{
			Assert.AreEqual( 
				_testInterfaceName.ToString(), 
				InterfaceControl.GetInterfaceControlParameters( _testInterfaceName.ToString() )[TABLES.Interface.InterfaceName].ToString()  );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetInterfaceControlParameters_Fail_1()
		{
			InterfaceControl.GetInterfaceControlParameters( null );
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetInterfaceControlParameters_Fail_2()
		{
			InterfaceControl.GetInterfaceControlParameters( Guid.Empty.ToString() );
		}
 
		[Test]
		public void UpdateInterface_Pass_1()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.InterfaceIPAddress, "127.0.0.1      " ); // DB column is char(15)
		}

		[Test]
		public void UpdateInterface_Pass_2()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.InterfacePortNumber, 55555 );
		}

		[Test]
		public void UpdateInterface_Pass_3()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.InterfaceFacilityId, "AAAAA" );
		}

		[Test]
		public void UpdateInterface_Pass_4()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.VbecsIPAddress, "127.0.0.1      " ); // DB column is char(15)
		}

		[Test]
		public void UpdateInterface_Pass_5()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.VbecsPortNumber, 55555 );
		}

		[Test]
		public void UpdateInterface_Pass_6()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.VbecsFacilityId, "AAAAA" );
		}

		[Test]
		public void UpdateInterface_Pass_7()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.AckTimeout, 777 );
		}

		[Test]
		public void UpdateInterface_Pass_8()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.ReTransmitAttempts, 55 );
		}

		[Test]
		public void UpdateInterface_Pass_9()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.PurgeSuccessfulMessage, 25 );
		}
		[Test]
		public void UpdateInterface_Pass_10()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.PurgeUnSuccessfulMessage, 20 );
		}

		[Test]
		public void UpdateInterface_Pass_11()
		{
			DoTestInterfaceFieldUpdate( TABLES.InterfaceControl.InterfaceAdministratorName, "test@test.com" );
		}

		//Nunit doesn't like "non-test" methods to start with "test" -- friggin NuIT!  I WANT THEM DEAD!
		public void DoTestInterfaceFieldUpdate( string fieldName, object testFieldValue )
		{
			_testInterfaceWorkingCopy[ fieldName ] = testFieldValue;
			ReserializeWorkingDataRowCopyAndCheckField( fieldName );
		}

		private void ReserializeWorkingDataRowCopyAndCheckField( string fieldName )
		{
			InterfaceControl.UpdateInterface( _testInterfaceWorkingCopy );
			DataRow _checkCopy = GetTestInterfaceControlParametersDataRow();

			Assert.AreEqual( _testInterfaceWorkingCopy[ fieldName ], _checkCopy[ fieldName ] );
		}

		private DataRow GetTestInterfaceControlParametersDataRow()
		{
			return InterfaceControl.GetInterfaceControlParameters( _testInterfaceName.ToString() );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void UpdateInterface_Fail()
		{
			InterfaceControl.UpdateInterface( null );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InterfaceControlConstructor_Pass()
		{
			// The constructor is private and cannot be instanciated,
			// therefore it cannot be unit tested.
		}
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InterfaceControlContructor_Fail()
		{
			// There are no failure criteria for the private constructor
			// since it cannot be instanciated.
		}
	}	
}
#endif
